package gov.va.vinci.dart.db.impl;

import java.util.List;

import javax.persistence.Query;

import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.biz.Role;
import gov.va.vinci.dart.db.RoleDAO;
import gov.va.vinci.dart.db.util.HibernateDAO;

public class RoleDAOImpl extends HibernateDAO implements RoleDAO {
	
	public Role findById(final int roleId)  throws ObjectNotFoundException {
		Query q = createQuery("from Role where id=:rid");
		q.setParameter("rid", roleId);
		return (Role)q.getSingleResult();
	}
	
	@SuppressWarnings("unchecked")
	public List<Role> listAll() {
		Query q = createQuery("from Role");
		return (List<Role>)q.getResultList();
	}

}
